
/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor China Ltd. 2008
*  ALL RIGHTS RESERVED
*
*  File Name: SCSI_Process.C
*                                                                          
*  Description: This file is to handle SCSI command       			    
*                                                                                     
*  Assembler:  Codewarrior for HC(S)08 V6.2
*                                            
*  Version: 2.5                                                         
*                                                                                                                                                        
*  Author: Patrick Yang                              
*                                                                                       
*  Location: Shanghai, P.R.China                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.0   2008.01.02  Patrick Yang  Initial version
* 2.0   2008.06.10  Derek Snell   Modified to work with USB MSD bootloader
* 2.1   2008.08.15  Derek Snell   Fixed SCSI issue to work with non-XP OSs
* 2.2   2008.08.25  Derek Snell   Renamed SCSI Inquiry to "Freescale USB Bootloader"
*                                 Stopped accepting write data from host after successful S19 transfer
* 2.3   2008.09.17  Derek Snell   Added SCSI 1E command for re-enumeration
* 2.4   2008.11.24  Derek Snell   Changed Inquiry command 0x12 response to clean up text
* 2.5   2009.01.13  Derek Snell   Added linker SEGMENTs for S08 version
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#include "derivative.h" /* include peripheral declarations */
#include "Bootloader_Headers.h"
#include "SCSI_Process.h"
#include "Fat16.h"

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/
byte  vCBW_Buf[31];       // CBW command buffer 
byte  vUSBCBWTag[4];      // CBW tag
byte  vCSWResult;         // CSW result
byte  vIdx;               // Local index            
byte  v_Bnum;           // Block number
dword	v_LBA;            // BLock address
dword	v_END_LBA;        // BLock address
//byte  vSCSIState;         // State of SCSI State Machine
byte  MultiLBAToken;
byte  BlockWriteDone;




/************************************************************************************
*************************************************************************************
* Global memory declarations
*************************************************************************************
************************************************************************************/

extern word vEP1_Cnt;
extern word vEP1Idx;
extern byte vEP1Data[512];
            
extern word vEP2Idx;
extern byte vEP2Data[512];

extern volatile tBDT EP2Rx;
extern byte vEP2RxBuf;
extern byte vEP1TxData;
extern byte vEP2RxData;

extern byte ICP_USB_State;

extern byte S19FileDone;
extern unsigned char BootloaderStatus;
extern unsigned char ReEnumerateNow;

/************************************************************************************
*************************************************************************************
*                                    Funcitons                                      *
*************************************************************************************
************************************************************************************/

void PollUSB (void);
void FATReadLBA(dword FAT_LBA,byte *pu8DataPointer);
void EP1_Load(void);

/********************************************************************
*********************************************************************
*       Capacity Info
*********************************************************************
********************************************************************/
const byte SCSI_ReadCapacity[SCSICapacitySize]= 
{
	0x00,       // Last Logical Block0
	0x1E,       // Last Logical Block1
	0x45,       // Last Logical Block2
	0xFF,       // Last Logical Block3
	0x00,       // Bytes per Sector0
	0x00,       // Bytes per Sector1
	0x02,       // Bytes per Sector2
	0x00        // Bytes per Sector3
};


/********************************************************************
*********************************************************************
*       Format Capacity Info
*********************************************************************
********************************************************************/
const byte SCSI_ReadFormatCapacity[SCSICapacityFormatSize]= 
{
	0x00,       // Reserved
	0x00,       // Reserved
	0x00,       // Reserved
  0x10,       // Capacity List Length
	0x00,       // Number of Blocks0
	0x1E,       // Number of Blocks1
	0x46,       // Number of Blocks2
	0x00,       // Number of Blocks3
	0x02,       // Formatted Media
	0x00,       // Bytes per Sector0
	0x02,       // Bytes per Sector1
	0x00,       // Bytes per Sector2
	0x00,       // Number of Blocks0
	0x1E,       // Number of Blocks1
	0x46,       // Number of Blocks2
	0x00,       // Number of Blocks3
	0x00,       // Reserved
	0x00,       // Bytes per Sector0
	0x02,       // Bytes per Sector1
	0x00,       // Bytes per Sector2
};




/*********************************************************
* Name: GetUSBOutFileData
*
* Desc: Waits for USB to read file data to write
*
* Parameter: None
*
* Return: None
*             
**********************************************************/
void GetUSBOutFileData(void)
{

      vEP2Idx =0;
        
      if(v_LBA == v_END_LBA) {
          BlockWriteDone = 1;
      } else {
          v_LBA++;
          while(vEP2Idx !=512)
            PollUSB();        
      }
   
}


/*********************************************************
* Name: SCSI_Init
*
* Desc: Initialize SCSI StateMachine
*
* Parameter: None
*
* Return: None
*             
**********************************************************/

void SCSI_Init(void)
{
    v_LBA = 0;
     
}

/*********************************************************
* Name: Send_CSW
*
* Desc: Send CSW back to Host
*
* Parameter: None
*
* Return: None
*             
**********************************************************/

void Send_CSW(void)
{
    vEP1Data[0] = 0x55;          // 00 byte0-3 Signature 0x55 0x53 0x42 0x52
    vEP1Data[1] = 0x53;   		    // 01 					
    vEP1Data[2] = 0x42;          // 02 
	  vEP1Data[3] = 0x53;          // 03 
	  vEP1Data[4] = vUSBCBWTag[0]; // 04 byte4-7 USB CBW Tag
	  vEP1Data[5] = vUSBCBWTag[1]; // 05 
	  vEP1Data[6] = vUSBCBWTag[2]; // 06 
	  vEP1Data[7] = vUSBCBWTag[3]; // 07 
	  vEP1Data[8] = 0x00;          // 08 byte8-11 USB byte residue 
	  vEP1Data[9] = 0x00;          // 09 
	  vEP1Data[10] = 0x00;          // 10 
	  vEP1Data[11] = 0x00;          // 11 
	  vEP1Data[12] = vCSWResult;    // 12 Status
	  
    vEP1Idx =0;
    vEP1_Cnt = 13;
    EP1_Load();

    ICP_USB_State = mICP_WAIT;
}


/*********************************************************
* Name: SCSIList00
*
* Desc: SCSI command 0x00 (Test unit ready) handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/
void SCSIList00(void)
{
  vCSWResult =kCSWPass;   
  Send_CSW();
  
}


/*********************************************************
* Name: SCSIList03
*
* Desc: SCSI command 0x03 (Request Sense) handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/
void SCSIList03(void) 
{
    vIdx=0;
    
    vEP1Data[vIdx++] = 0x70;        // 00 error code
    vEP1Data[vIdx++] = 0x00;   		  // 01 reserved				
    vEP1Data[vIdx++] = 0x05;        // 02 sense key
	  vEP1Data[vIdx++] = 0x00;        // 03 03-06 information
	  vEP1Data[vIdx++] = 0x00;        // 04 
	  vEP1Data[vIdx++] = 0x00;        // 05 
	  vEP1Data[vIdx++] = 0x00;        // 06 
	  vEP1Data[vIdx++] = 0x0c;        // 07 additional sense length
	  vEP1Data[vIdx++] = 0x00;        // 08 08-11 command specific information
	  vEP1Data[vIdx++] = 0x00;        // 09 
	  vEP1Data[vIdx++] = 0x00;        // 10 
	  vEP1Data[vIdx++] = 0x00;        // 11 
	  vEP1Data[vIdx++] = 0x24;        // 12 additional sense code
	  vEP1Data[vIdx++] = 0x00;        // 13 additional sense code qualifer
	  vEP1Data[vIdx++] = 0x00;        // 14 file replaceable unit code
	  vEP1Data[vIdx++] = 0x00;        // 15 15-17 sense key specific
	  vEP1Data[vIdx++] = 0x00;        // 16 
	  vEP1Data[vIdx++] = 0x00;        // 17 
	  
	  
	  vCSWResult =kCSWPass;  
    vEP1_Cnt = vIdx;
    EP1_Load();
    ICP_USB_State = cCSW; 
}


/*********************************************************
* Name: SCSIList12
*
* Desc: SCSI command 0x12 (Inquiry) handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/
void SCSIList12(void) 
{
    
    vIdx=0;
    
    vEP1Data[0] = 0x00;         // 00 device type
    vEP1Data[1] = 0x80;   		  // 01 removable					
    vEP1Data[2] = 0x00;         // 02 SCSI 2 compatible
	  vEP1Data[3] = 0x02;         // 03 data format
	  vEP1Data[4] = 0x1F;         // 04 additional lenght=31
	  vEP1Data[5] = 0x00;         // 05 
	  vEP1Data[6] = 0x00;         // 06 
	  vEP1Data[7] = 0x00;         // 07 
	  vEP1Data[8] = 'F';                
	  vEP1Data[9] = 'S';       
	  vEP1Data[10] ='L';      
	  vEP1Data[11] =' ';      
	  vEP1Data[12] =' ';     
	  vEP1Data[13] ='U';   
	  vEP1Data[14] ='S';     
	  vEP1Data[15] ='B';     
	  vEP1Data[16] =' ';   
	  vEP1Data[17] ='B';
	  vEP1Data[18] ='o';
	  vEP1Data[19] ='o';
	  vEP1Data[20] ='t';
	  vEP1Data[21] ='l';
	  vEP1Data[22] ='o';      
	  vEP1Data[23] ='a';      
	  vEP1Data[24] ='d';      
	  vEP1Data[25] ='e';     
    vEP1Data[26] ='r';      
	  vEP1Data[27] =' ';     
	  vEP1Data[28] =' ';      
	  vEP1Data[29] =' ';     
	  vEP1Data[30] =' ';      
	  vEP1Data[31] =' ';    
	  vEP1Data[32] = 0x30;        // 32 '0'
	  vEP1Data[33] = 0x30;        // 33 '0'
	  vEP1Data[34] = 0x30;        // 34 '0'
	  vEP1Data[35] = 0x31;        // 35 '1'
	  
	  vCSWResult = kCSWPass;
	  vEP1_Cnt = 36;
    EP1_Load();
    
    ICP_USB_State = cCSW; 
	  
}


/*********************************************************
* Name: SCSIList1A
*
* Desc: SCSI command 0x1A (Mode Sense) handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/
void SCSIList1A(void)
{
   vEP1Data[0] = 0x03;          // page mode
   vEP1Data[1] = 0x00;
    vEP1Data[2] = 0x00;          // unprotect, protect is 0x80
   vEP1Data[3] = 0x00;
   
   vCSWResult = kCSWPass;
   vEP1_Cnt = 4;
   EP1_Load();
   ICP_USB_State = cCSW; 
}
   
   
/*********************************************************
* Name: SCSIList23
*
* Desc: SCSI command 0x23 (Read Format Capacity) handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/  
void SCSIList23(void) 
{
   byte i;
   
   // Copy Read Format Capacity info to USB buffer
   for(i=0;i<SCSICapacityFormatSize;i++)
        vEP1Data[i] = SCSI_ReadFormatCapacity[i];

   vCSWResult = kCSWPass;
   vEP1_Cnt = SCSICapacityFormatSize;
   EP1_Load();
   ICP_USB_State = cCSW; 
}   
   



/*********************************************************
* Name: SCSIList25
*
* Desc: SCSI command 0x25 (Read Capacity) handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/  
void SCSIList25(void) 
{
   byte i;
   
   // Copy Read Capacity info to USB buffer
   for(i=0;i<SCSICapacitySize;i++)
        vEP1Data[i] = SCSI_ReadCapacity[i];

   vCSWResult = kCSWPass;
   vEP1_Cnt = 8;
   EP1_Load();
   ICP_USB_State = cCSW; 
}   
   



/*********************************************************
* Name: SCSIList28
*
* Desc: SCSI command 0x28 (Read ) handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/ 
void SCSIList28(void)
{
   byte i;
   
   v_LBA  = (dword)(vCBW_Buf[kSCSI10LBAByte3])<<24;
   v_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte2])<<16;
   v_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte1])<<8;
   v_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte0]);

   v_Bnum = vCBW_Buf[kSCSI10XferLength0];
   
   vCSWResult = kCSWPass;
   MultiLBAToken = 0;
   
   for(i=0;i<v_Bnum;i++)
   {     
      FATReadLBA(v_LBA,vEP1Data);
      ICP_USB_State = cEP1Tx; 
      vEP1Idx =0;
      vEP1_Cnt=512;
      if(i == 0)               // for first LBA, load buffer
          EP1_Load();
      else {
          while(MultiLBAToken)     // wait for TOKDNEF to be processed
              PollUSB();
      }
      
      while(vEP1_Cnt) 
        PollUSB();      // Check for interrupt flags
      MultiLBAToken = 1;
      v_LBA++;
   }
   
   
   ICP_USB_State = cCSW;  
    
}



/*********************************************************
* Name: SCSIList2A
*
* Desc: SCSI command 0x2A (Write) handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/
void SCSIList2A(void)
{
   
   v_LBA  = (dword)(vCBW_Buf[kSCSI10LBAByte3])<<24;
   v_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte2])<<16;
   v_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte1])<<8;
   v_LBA |= (dword)(vCBW_Buf[kSCSI10LBAByte0]);
   
   v_Bnum = vCBW_Buf[kSCSI10XferLength0];
   v_END_LBA = v_LBA + v_Bnum - 1;
   BlockWriteDone = FALSE;

   while(vEP2Idx !=512)
      PollUSB();  

   if(S19FileDone) {
    
      while(!BlockWriteDone) {    // Receive all USB data
          if((v_LBA >= FATDataSec0) 
          && ((BootloaderStatus == BootloaderReady) || (BootloaderStatus == BootloaderStarted)))     // Host writing first file to Data sector of drive
          {
              S19FileDone = FALSE;
              return;
          } else                         // Host trying to write to FAT table
              GetUSBOutFileData();
      }
   
      vCSWResult = kCSWPass;      // Send Status transaction
      Send_CSW();
   }
      
}




/*********************************************************
* Name: SCSI_NotSupport
*
* Desc: Handle Not support SCSI command 
*
* Parameter: None
*
* Return: None
*             
**********************************************************/
void SCSI_NotSupport(void) {
  byte count;
  
  vCSWResult= kCSWFailed;
  
  count=(byte)(vCBW_Buf[kCBWXferLength0] | vCBW_Buf[kCBWXferLength1] | vCBW_Buf[kCBWXferLength2] | vCBW_Buf[kCBWXferLength3]);
  
  if(count) 
  {
    if( (vCBW_Buf[kCBWFlags] & kCBWDirection) == kHost2Device)
		{
			STALL_EP2;		// STALL OUT endpoint
			Send_CSW();
		}
		else 
		{              // device to host
		  vEP1_Cnt = 0;
		  EP1_Load();
		  ICP_USB_State = cCSW; 
		}
	}
	
	else { // zero data
      Send_CSW();
	}
} 
 
/*********************************************************
* Name: SCSI_Process
*
* Desc: SCSI command handler
*
* Parameter: None
*
* Return: None
*             
**********************************************************/
void SCSI_Process(void)
{
    
    vUSBCBWTag[0]=vCBW_Buf[kCBWTag0];
    vUSBCBWTag[1]=vCBW_Buf[kCBWTag1];
    vUSBCBWTag[2]=vCBW_Buf[kCBWTag2];
    vUSBCBWTag[3]=vCBW_Buf[kCBWTag3];   
 
    vEP1Idx =0;
 
    // Check if write complete and should re-enumerate
    if(ReEnumerateNow != DONE) {
        if((BootloaderStatus != BootloaderReady) && (BootloaderStatus != BootloaderStarted)){
        
            // File was already written
            if(vCBW_Buf[kCBWSCSICommand] != 0x2A) {
            
                // SCSI Command received was not another write
                ReEnumerateNow = YES; 
            }
        }
    }
    
    switch(vCBW_Buf[kCBWSCSICommand])
    {
      case 0x00:
        SCSIList00();
        break;
        
      case 0x03:
        SCSIList03();
        break;
        
      case 0x12:
        SCSIList12();
        break;
      
      case 0x1A:
        SCSIList1A();
        break;
        
      case 0x25:
        SCSIList25();
        break;
      
      case 0x28:
        SCSIList28();
        break;
        
      case 0x2A:
        SCSIList2A();
        break;
        
      default:
        SCSI_NotSupport();
        break;
    }
      
}

